const MEMBER_VIEW_KEY = "dx_member_view";
const PENDING_VIEW_KEY = "dx_ext_pending_view";

function getSessionPayload() {
  const token = document.documentElement.dataset.dxpToken || localStorage.getItem("dxp_token") || "";
  const userStr = document.documentElement.dataset.dxpUser || localStorage.getItem("dxp_user") || "{}";
  let user = {};
  try { user = JSON.parse(userStr); } catch (e) { }

  return {
    token,
    user: {
      email: user.email || user.username || "",
      name: user.name || "",
      role: user.role || "user",
      isPremium: user.isPremium === true || user.status === 'premium' || user.role === 'admin'
    },
    baseUrl: window.location.origin
  };
}


function clearDashboardSession() {
  const keys = ["dxp_token", "dxp_user"];

  keys.forEach((key) => {
    try {
      localStorage.removeItem(key);
    } catch (_) {
      // ignore
    }
  });
}


function setMemberView(viewName) {
  const allowedViews = new Set(["dashboard", "purchases", "tutorial", "request"]);
  const selected = allowedViews.has(viewName) ? viewName : "dashboard";
  sessionStorage.setItem(MEMBER_VIEW_KEY, selected);
}

function applyPendingViewFromExtensionStorage() {
  try {
    chrome.storage.local.get([PENDING_VIEW_KEY], (result) => {
      const pendingView = result?.[PENDING_VIEW_KEY];
      if (!pendingView) return;
      setMemberView(pendingView);
      chrome.storage.local.remove([PENDING_VIEW_KEY]);
    });
  } catch (_) {
    // ignore
  }
}

chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (!request || !request.action) return false;

  if (request.action === "myam_project_get_session") {
    sendResponse(getSessionPayload());
    return false;
  }

  if (request.action === "myam_project_clear_session") {
    clearDashboardSession();
    sendResponse({ success: true });
    return false;
  }

  if (request.action === "myam_project_set_member_view") {
    setMemberView(String(request.view || "dashboard"));
    sendResponse({ success: true });
    return false;
  }

  return false;
});

applyPendingViewFromExtensionStorage();

// Listener untuk mendeteksi event logout dari main.js (Website)
window.addEventListener('myam_project_logout', () => {
  try {
    chrome.runtime.sendMessage({ action: "myam_force_logout" });
  } catch (e) {
    console.warn("Ext context invalidated or error sending logout message", e);
  }
});
