const EXT_KEYS = {
    token: "dxp_token",
    baseUrl: "dx_ext_base_url",
    user: "dxp_user",
    pendingView: "dx_ext_pending_view",
    managedCookies: "dx_ext_managed_cookies",
    settings: "dx_ext_settings"
};

chrome.runtime.onInstalled.addListener(() => {
    console.log("MYAM Project Extension installed.");
    // Mulai alarm untuk cek sesi tiap 1 menit
    chrome.alarms.create("checkSession", { periodInMinutes: 1 });
});

chrome.alarms.onAlarm.addListener((alarm) => {
    if (alarm.name === "checkSession") {
        pollSession();
    }
});

chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
    if (message && message.action === "myam_force_logout") {
        handleSessionInvalid();
    }
});

async function storageGet(keys) {
    return new Promise((resolve) => {
        chrome.storage.local.get(keys, (result) => resolve(result || {}));
    });
}

async function storageRemove(keys) {
    return new Promise((resolve) => {
        chrome.storage.local.remove(keys, () => resolve());
    });
}

async function clearManagedCookies() {
    const result = await storageGet([EXT_KEYS.managedCookies]);
    const cookies = result[EXT_KEYS.managedCookies] || [];

    if (cookies.length === 0) return;

    for (const cookie of cookies) {
        await new Promise((resolve) => {
            chrome.cookies.remove({ url: cookie.url, name: cookie.name }, () => resolve());
        });
    }

    await storageRemove([EXT_KEYS.managedCookies]);
    console.log(`Background: Terhapus ${cookies.length} managed cookies.`);
}

async function handleSessionInvalid() {
    console.warn("Background: Sesi tidak valid. Membersihkan kredensial.");
    await clearManagedCookies();
    await storageRemove([EXT_KEYS.token, EXT_KEYS.user]);
}

async function pollSession() {
    const result = await storageGet([EXT_KEYS.token, EXT_KEYS.baseUrl]);
    const token = result[EXT_KEYS.token];
    const baseUrl = result[EXT_KEYS.baseUrl];

    // Jika belum login, abaikan - TETAPI pastikan cookie lama ikut terhapus jika masih tersisa
    if (!token || !baseUrl) {
        await handleSessionInvalid();
        return;
    }

    try {
        const currentManifestVersion = chrome.runtime.getManifest().version;
        const response = await fetch(`${baseUrl}/api/session`, {
            method: "GET",
            headers: {
                "Authorization": `Bearer ${token}`,
                "x-extension-version": currentManifestVersion
            }
        });

        if (response.status === 401 || response.status === 403) {
            await handleSessionInvalid();
        } else if (!response.ok) {
            console.warn(`Background: Gagal cek sesi (HTTP ${response.status})`);
        } else {
            const payload = await response.json();
            if (!payload.status) {
                await handleSessionInvalid();
            } else if (!payload.isPremium && payload.role !== 'admin') {
                // Sesi valid tapi premium sudah habis
                await clearManagedCookies(); // Cabut akses premiumnya
            }
        }
    } catch (e) {
        console.error("Background: Error polling session", e);
    }
}
